/**
 * Application Constants
 */

module.exports = {
  // Pagination
  DEFAULT_PAGE: 1,
  DEFAULT_LIMIT: 10,
  MAX_LIMIT: 100,

  // File upload
  MAX_FILE_SIZE: 10 * 1024 * 1024, // 10MB
  MAX_FILES: 10,
  ALLOWED_FILE_TYPES: [
    'image/jpeg',
    'image/jpg',
    'image/png',
    'image/webp',
    'application/pdf',
    'application/msword',
    'application/vnd.openxmlformats-officedocument.wordprocessingml.document'
  ],

  // Property status
  PROPERTY_STATUS: {
    AVAILABLE: 'available',
    OCCUPIED: 'occupied',
    MAINTENANCE: 'maintenance',
    UNAVAILABLE: 'unavailable'
  },

  // Lease status
  LEASE_STATUS: {
    ACTIVE: 'active',
    EXPIRED: 'expired',
    TERMINATED: 'terminated',
    PENDING: 'pending'
  },

  // Payment status
  PAYMENT_STATUS: {
    PENDING: 'pending',
    PAID: 'paid',
    OVERDUE: 'overdue',
    FAILED: 'failed',
    REFUNDED: 'refunded'
  },

  // Maintenance status
  MAINTENANCE_STATUS: {
    PENDING: 'pending',
    IN_PROGRESS: 'in_progress',
    COMPLETED: 'completed',
    CANCELLED: 'cancelled'
  },

  // Maintenance priority
  MAINTENANCE_PRIORITY: {
    LOW: 'low',
    MEDIUM: 'medium',
    HIGH: 'high',
    EMERGENCY: 'emergency'
  },

  // Maintenance categories
  MAINTENANCE_CATEGORIES: {
    PLUMBING: 'plumbing',
    ELECTRICAL: 'electrical',
    HVAC: 'hvac',
    APPLIANCE: 'appliance',
    STRUCTURAL: 'structural',
    COSMETIC: 'cosmetic',
    PEST_CONTROL: 'pest_control',
    OTHER: 'other'
  },

  // Property types
  PROPERTY_TYPES: [
    'apartment',
    'house',
    'condo',
    'townhouse',
    'studio',
    'villa'
  ],

  // Payment methods
  PAYMENT_METHODS: [
    'credit_card',
    'debit_card',
    'bank_transfer',
    'cash',
    'check',
    'online'
  ],

  // Amenities
  AMENITIES: [
    'wifi',
    'parking',
    'pool',
    'gym',
    'air_conditioning',
    'heating',
    'laundry',
    'dishwasher',
    'pet_friendly',
    'furnished',
    'balcony',
    'garden',
    'security',
    'elevator',
    'wheelchair_accessible',
    'storage',
    'parking_garage',
    'concierge',
    'rooftop',
    'fireplace'
  ],

  // Features
  FEATURES: [
    'hardwood_floor',
    'carpet',
    'fireplace',
    'central_air',
    'window_coverings',
    'storage',
    'walk_in_closet',
    'patio',
    'garage',
    'basement',
    'attic',
    'garden',
    'pool',
    'hot_tub',
    'gym',
    'security_system',
    'smart_home',
    'solar_panels',
    'ev_charging'
  ],

  // Notification types
  NOTIFICATION_TYPES: {
    PAYMENT_REMINDER: 'payment_reminder',
    MAINTENANCE_UPDATE: 'maintenance_update',
    LEASE_EXPIRY: 'lease_expiry',
    NEW_MESSAGE: 'new_message',
    SYSTEM_ALERT: 'system_alert',
    BOOKING_CONFIRMATION: 'booking_confirmation',
    PAYMENT_RECEIVED: 'payment_received',
    MAINTENANCE_SCHEDULED: 'maintenance_scheduled',
    LEASE_RENEWAL: 'lease_renewal',
    SECURITY_DEPOSIT: 'security_deposit'
  },

  // Document types
  DOCUMENT_TYPES: {
    LEASE_AGREEMENT: 'lease_agreement',
    ID_PROOF: 'id_proof',
    INCOME_PROOF: 'income_proof',
    PROPERTY_DOCUMENT: 'property_document',
    MAINTENANCE_REPORT: 'maintenance_report',
    INSPECTION_REPORT: 'inspection_report',
    INSURANCE_DOCUMENT: 'insurance_document',
    OTHER: 'other'
  },

  // Audit log actions
  AUDIT_ACTIONS: {
    USER_CREATED: 'user_created',
    USER_UPDATED: 'user_updated',
    USER_DELETED: 'user_deleted',
    PROPERTY_CREATED: 'property_created',
    PROPERTY_UPDATED: 'property_updated',
    PROPERTY_DELETED: 'property_deleted',
    LEASE_CREATED: 'lease_created',
    LEASE_UPDATED: 'lease_updated',
    LEASE_TERMINATED: 'lease_terminated',
    PAYMENT_CREATED: 'payment_created',
    PAYMENT_PROCESSED: 'payment_processed',
    PAYMENT_REFUNDED: 'payment_refunded',
    MAINTENANCE_CREATED: 'maintenance_created',
    MAINTENANCE_UPDATED: 'maintenance_updated',
    MAINTENANCE_COMPLETED: 'maintenance_completed'
  },

  // Entity types for audit logs
  ENTITY_TYPES: {
    USER: 'user',
    PROPERTY: 'property',
    LEASE: 'lease',
    PAYMENT: 'payment',
    MAINTENANCE: 'maintenance',
    DOCUMENT: 'document',
    REVIEW: 'review'
  },

  // Message types
  MESSAGE_TYPES: {
    TEXT: 'text',
    IMAGE: 'image',
    FILE: 'file',
    SYSTEM: 'system'
  },

  // Review types
  REVIEW_TYPES: {
    PROPERTY: 'property',
    LANDLORD: 'landlord',
    TENANT: 'tenant'
  },

  // Currency codes
  CURRENCY_CODES: {
    USD: 'USD',
    EUR: 'EUR',
    GBP: 'GBP',
    CAD: 'CAD',
    AUD: 'AUD'
  },

  // Time intervals (in milliseconds)
  TIME_INTERVALS: {
    MINUTE: 60 * 1000,
    HOUR: 60 * 60 * 1000,
    DAY: 24 * 60 * 60 * 1000,
    WEEK: 7 * 24 * 60 * 60 * 1000,
    MONTH: 30 * 24 * 60 * 60 * 1000,
    YEAR: 365 * 24 * 60 * 60 * 1000
  },

  // Cache TTL (Time To Live) in seconds
  CACHE_TTL: {
    SHORT: 300,      // 5 minutes
    MEDIUM: 3600,    // 1 hour
    LONG: 86400,     // 24 hours
    VERY_LONG: 604800 // 7 days
  },

  // Rate limiting
  RATE_LIMITS: {
    AUTH: {
      WINDOW_MS: 15 * 60 * 1000, // 15 minutes
      MAX_REQUESTS: 5
    },
    API: {
      WINDOW_MS: 15 * 60 * 1000, // 15 minutes
      MAX_REQUESTS: 100
    },
    UPLOAD: {
      WINDOW_MS: 60 * 60 * 1000, // 1 hour
      MAX_REQUESTS: 10
    }
  },

  // Security
  SECURITY: {
    PASSWORD_MIN_LENGTH: 8,
    PASSWORD_RESET_EXPIRY: 60 * 60 * 1000, // 1 hour
    SESSION_TIMEOUT: 24 * 60 * 60 * 1000, // 24 hours
    MAX_LOGIN_ATTEMPTS: 5,
    LOCKOUT_DURATION: 30 * 60 * 1000 // 30 minutes
  },

  // Business rules
  BUSINESS_RULES: {
    LATE_FEE_PERCENTAGE: 5, // 5% late fee
    LATE_FEE_GRACE_PERIOD: 5, // 5 days grace period
    SECURITY_DEPOSIT_MULTIPLIER: 1.5, // 1.5x monthly rent
    LEASE_RENEWAL_NOTICE_DAYS: 60, // 60 days notice for lease renewal
    MAINTENANCE_RESPONSE_TIME: 48 // 48 hours for maintenance response
  },

  // API response codes
  API_CODES: {
    SUCCESS: 200,
    CREATED: 201,
    BAD_REQUEST: 400,
    UNAUTHORIZED: 401,
    FORBIDDEN: 403,
    NOT_FOUND: 404,
    CONFLICT: 409,
    VALIDATION_ERROR: 422,
    TOO_MANY_REQUESTS: 429,
    SERVER_ERROR: 500,
    SERVICE_UNAVAILABLE: 503
  },

  // Environment modes
  ENVIRONMENT: {
    DEVELOPMENT: 'development',
    PRODUCTION: 'production',
    TEST: 'test'
  }
};