const mysql = require('mysql2/promise');
const fs = require('fs').promises;
const path = require('path');

const setupUnifiedDatabase = async () => {
  let connection;
  
  try {
    // Connect to MySQL without specifying database
    connection = await mysql.createConnection({
      host: process.env.DB_HOST || 'localhost',
      user: process.env.DB_USER || 'root',
      password: process.env.DB_PASSWORD || '',
      multipleStatements: true
    });

    console.log('Connected to MySQL server');

    // Read and execute the SQL file
    const sqlFile = path.join(__dirname, 'createUnifiedDatabase.sql');
    const sqlContent = await fs.readFile(sqlFile, 'utf8');

    console.log('Executing database schema...');
    await connection.execute(sqlContent);

    console.log('✅ Unified database created successfully!');
    console.log('📊 Database: stayspotco_stayspot');
    console.log('📋 Tables created:');
    console.log('   - users (central user management)');
    console.log('   - properties');
    console.log('   - leases');
    console.log('   - payments');
    console.log('   - maintenance_requests');
    console.log('   - notifications');
    console.log('   - chat_messages');
    console.log('   - partnership_applications');
    console.log('   - transportation_bookings');
    console.log('   - analytics_data');
    console.log('   - audit_logs');
    console.log('   - system_settings');
    console.log('🔍 Views created:');
    console.log('   - active_leases');
    console.log('   - property_summary');
    console.log('   - payment_summary');

  } catch (error) {
    console.error('❌ Error setting up database:', error.message);
    throw error;
  } finally {
    if (connection) {
      await connection.end();
    }
  }
};

// Run if called directly
if (require.main === module) {
  require('dotenv').config();
  setupUnifiedDatabase()
    .then(() => {
      console.log('Database setup completed successfully');
      process.exit(0);
    })
    .catch((error) => {
      console.error('Database setup failed:', error);
      process.exit(1);
    });
}

module.exports = setupUnifiedDatabase;