const { sequelize } = require('../config/database');
const { createAssociations } = require('../models/associations');

const migrateDatabase = async () => {
  try {
    console.log('Starting database migration...');
    
    // Test connection
    await sequelize.authenticate();
    console.log('✅ Database connection established.');

    // Create all tables
    await sequelize.sync({ force: false, alter: true });
    console.log('✅ All tables synchronized successfully.');

    // Create model associations
    createAssociations();
    console.log('✅ Model associations created.');

    console.log('🎉 Database migration completed successfully!');
    process.exit(0);
  } catch (error) {
    console.error('❌ Database migration failed:', error);
    process.exit(1);
  }
};

// Run migration if called directly
if (require.main === module) {
  migrateDatabase();
}

module.exports = migrateDatabase;