const express = require('express');
const router = express.Router();
const uploadController = require('../controllers/uploadController');
const { authenticateToken } = require('../middleware/auth');
const { handleUpload, uploadToCloudinaryMiddleware, setUploadFolder } = require('../middleware/upload');

// Upload single file
router.post(
  '/single',
  authenticateToken,
  handleUpload,
  uploadToCloudinaryMiddleware,
  uploadController.uploadSingle
);

// Upload multiple files
router.post(
  '/multiple',
  authenticateToken,
  handleUpload,
  uploadToCloudinaryMiddleware,
  uploadController.uploadMultiple
);

// Upload property images
router.post(
  '/properties',
  authenticateToken,
  handleUpload,
  setUploadFolder('properties'),
  uploadToCloudinaryMiddleware,
  uploadController.uploadPropertyImages
);

// Upload document
router.post(
  '/documents',
  authenticateToken,
  handleUpload,
  setUploadFolder('documents'),
  uploadToCloudinaryMiddleware,
  uploadController.uploadDocument
);

// Upload avatar
router.post(
  '/avatar',
  authenticateToken,
  handleUpload,
  setUploadFolder('avatars'),
  uploadToCloudinaryMiddleware,
  uploadController.uploadAvatar
);

// Delete uploaded file
router.delete(
  '/:publicId',
  authenticateToken,
  uploadController.deleteFile
);

// Get upload configuration
router.get(
  '/config',
  authenticateToken,
  uploadController.getUploadConfig
);

module.exports = router;