const express = require('express');
const router = express.Router();

// In-memory storage (replace with actual database)
let partnerships = [];

// POST /api/partnerships - Submit partnership application
router.post('/', async (req, res) => {
  try {
    const {
      companyName,
      contactPerson,
      email,
      phone,
      website,
      partnershipType,
      companySize,
      description,
      experience,
      submittedAt
    } = req.body;

    // Validate required fields
    if (!companyName || !contactPerson || !email || !phone || !partnershipType || !description) {
      return res.status(400).json({
        success: false,
        message: 'Missing required fields'
      });
    }

    // Create partnership application
    const partnership = {
      id: Date.now().toString(),
      companyName,
      contactPerson,
      email,
      phone,
      website: website || '',
      partnershipType,
      companySize,
      description,
      experience: experience || '',
      submittedAt: submittedAt || new Date().toISOString(),
      status: 'pending'
    };

    partnerships.push(partnership);

    res.status(201).json({
      success: true,
      message: 'Partnership application submitted successfully',
      data: partnership
    });

  } catch (error) {
    console.error('Error creating partnership application:', error);
    res.status(500).json({
      success: false,
      message: 'Internal server error'
    });
  }
});

// GET /api/partnerships - Get all partnership applications
router.get('/', async (req, res) => {
  try {
    res.json({
      success: true,
      data: partnerships
    });
  } catch (error) {
    console.error('Error fetching partnerships:', error);
    res.status(500).json({
      success: false,
      message: 'Internal server error'
    });
  }
});

module.exports = router;