const express = require('express');
const router = express.Router();

// Import all route modules
const authRoutes = require('./auth');
const userRoutes = require('./users');
const propertyRoutes = require('./properties');
const leaseRoutes = require('./leases');
const paymentRoutes = require('./payments');
const maintenanceRoutes = require('./maintenance');
const dashboardRoutes = require('./dashboard');
const notificationRoutes = require('./notifications');
const uploadRoutes = require('./uploads');
const reportRoutes = require('./reports');

// Mount routes
router.use('/auth', authRoutes);
router.use('/users', userRoutes);
router.use('/properties', propertyRoutes);
router.use('/leases', leaseRoutes);
router.use('/payments', paymentRoutes);
router.use('/maintenance', maintenanceRoutes);
router.use('/dashboard', dashboardRoutes);
router.use('/notifications', notificationRoutes);
router.use('/uploads', uploadRoutes);
router.use('/reports', reportRoutes);

// API health check
router.get('/health', (req, res) => {
  res.status(200).json({
    success: true,
    message: 'StaySpot API is healthy',
    timestamp: new Date().toISOString(),
    version: '1.0.0'
  });
});

// API documentation route
router.get('/docs', (req, res) => {
  res.json({
    success: true,
    message: 'StaySpot API Documentation',
    endpoints: {
      auth: '/api/auth',
      users: '/api/users',
      properties: '/api/properties',
      leases: '/api/leases',
      payments: '/api/payments',
      maintenance: '/api/maintenance',
      dashboard: '/api/dashboard',
      notifications: '/api/notifications',
      uploads: '/api/uploads',
      reports: '/api/reports'
    }
  });
});

module.exports = router;