const express = require('express');
const router = express.Router();

// Get property analytics
router.get('/property/:id', async (req, res) => {
  try {
    const { id } = req.params;
    const { days = 30 } = req.query;
    
    // Mock analytics data
    const analytics = {
      propertyId: id,
      period: `${days} days`,
      totalViews: 1250,
      totalInquiries: 89,
      averageOccupancy: 95.5,
      totalRevenue: 125000,
      dailyData: Array.from({ length: parseInt(days) }, (_, i) => ({
        date: new Date(Date.now() - i * 24 * 60 * 60 * 1000).toISOString().split('T')[0],
        views: Math.floor(Math.random() * 50) + 10,
        inquiries: Math.floor(Math.random() * 10) + 1,
        revenue: Math.floor(Math.random() * 5000) + 20000
      })).reverse()
    };
    
    res.json(analytics);
  } catch (error) {
    res.status(500).json({ error: error.message });
  }
});

// Get dashboard analytics
router.get('/dashboard', async (req, res) => {
  try {
    const analytics = {
      totalProperties: 156,
      occupiedProperties: 142,
      totalTenants: 1847,
      monthlyRevenue: 2450000,
      maintenanceRequests: 23,
      newApplications: 67,
      occupancyRate: 91.0,
      revenueGrowth: 12.5
    };
    
    res.json(analytics);
  } catch (error) {
    res.status(500).json({ error: error.message });
  }
});

module.exports = router;