"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FormatterTypes = void 0;
const formatters_1 = __importStar(require("@json2csv/formatters"));
const utils_js_1 = require("./utils.js");
var FormatterTypes;
(function (FormatterTypes) {
    FormatterTypes["header"] = "header";
    FormatterTypes["undefined"] = "undefined";
    FormatterTypes["boolean"] = "boolean";
    FormatterTypes["number"] = "number";
    FormatterTypes["bigint"] = "bigint";
    FormatterTypes["string"] = "string";
    FormatterTypes["symbol"] = "symbol";
    FormatterTypes["function"] = "function";
    FormatterTypes["object"] = "object";
})(FormatterTypes || (exports.FormatterTypes = FormatterTypes = {}));
class JSON2CSVBase {
    constructor(opts) {
        this.opts = this.preprocessOpts(opts);
    }
    /**
     * Check passing opts and set defaults.
     *
     * @param {Json2CsvOptions} opts Options object containing fields,
     * delimiter, default value, header, etc.
     */
    preprocessOpts(opts) {
        const processedOpts = Object.assign({}, opts);
        if (processedOpts.fields) {
            processedOpts.fields = this.preprocessFieldsInfo(processedOpts.fields, processedOpts.defaultValue);
        }
        processedOpts.transforms = processedOpts.transforms || [];
        const stringFormatter = (processedOpts.formatters && processedOpts.formatters['string']) ||
            (0, formatters_1.string)();
        const objectFormatter = (0, formatters_1.object)({ stringFormatter });
        const defaultFormatters = {
            header: stringFormatter,
            undefined: formatters_1.default,
            boolean: formatters_1.default,
            number: (0, formatters_1.number)(),
            bigint: formatters_1.default,
            string: stringFormatter,
            symbol: (0, formatters_1.symbol)({ stringFormatter }),
            function: objectFormatter,
            object: objectFormatter,
        };
        processedOpts.formatters = Object.assign(Object.assign({}, defaultFormatters), processedOpts.formatters);
        processedOpts.delimiter = processedOpts.delimiter || ',';
        processedOpts.eol = processedOpts.eol || '\n';
        processedOpts.header = processedOpts.header !== false;
        processedOpts.includeEmptyRows = processedOpts.includeEmptyRows || false;
        processedOpts.withBOM = processedOpts.withBOM || false;
        return processedOpts;
    }
    /**
     * Check and normalize the fields configuration.
     *
     * @param {(string|object)[]} fields Fields configuration provided by the user
     * or inferred from the data
     * @returns {object[]} preprocessed FieldsInfo array
     */
    preprocessFieldsInfo(fields, globalDefaultValue) {
        return fields.map((fieldInfo) => {
            if (typeof fieldInfo === 'string') {
                return {
                    label: fieldInfo,
                    value: (row) => (0, utils_js_1.getProp)(row, fieldInfo, globalDefaultValue),
                };
            }
            if (typeof fieldInfo === 'object') {
                const defaultValue = 'default' in fieldInfo ? fieldInfo.default : globalDefaultValue;
                if (typeof fieldInfo.value === 'string') {
                    const fieldPath = fieldInfo.value;
                    return {
                        label: fieldInfo.label || fieldInfo.value,
                        value: (row) => (0, utils_js_1.getProp)(row, fieldPath, defaultValue),
                    };
                }
                if (typeof fieldInfo.value === 'function') {
                    const label = fieldInfo.label || fieldInfo.value.name || '';
                    const field = { label, default: defaultValue };
                    const valueGetter = fieldInfo.value;
                    return {
                        label,
                        value(row) {
                            const value = valueGetter(row, field);
                            return value === undefined ? defaultValue : value;
                        },
                    };
                }
            }
            throw new Error('Invalid field info option. ' + JSON.stringify(fieldInfo));
        });
    }
    /**
     * Create the title row with all the provided fields as column headings
     *
     * @returns {String} titles as a string
     */
    getHeader() {
        return (0, utils_js_1.fastJoin)(this.opts.fields.map((fieldInfo) => this.opts.formatters.header(fieldInfo.label)), this.opts.delimiter);
    }
    /**
     * Preprocess each object according to the given transforms (unwind, flatten, etc.).
     * @param {Object} row JSON object to be converted in a CSV row
     */
    preprocessRow(row) {
        return this.opts.transforms.reduce((rows, transform) => rows.map((row) => transform(row)).reduce(utils_js_1.flattenReducer, []), [row]);
    }
    /**
     * Create the content of a specific CSV row
     *
     * @param {Object} row JSON object to be converted in a CSV row
     * @returns {String} CSV string (row)
     */
    processRow(row) {
        if (!row) {
            return undefined;
        }
        const processedRow = this.opts.fields.map((fieldInfo) => this.processCell(row, fieldInfo));
        if (!this.opts.includeEmptyRows &&
            processedRow.every((field) => field === '')) {
            return undefined;
        }
        return (0, utils_js_1.fastJoin)(processedRow, this.opts.delimiter);
    }
    /**
     * Create the content of a specfic CSV row cell
     *
     * @param {Object} row JSON object representing the  CSV row that the cell belongs to
     * @param {FieldInfo} fieldInfo Details of the field to process to be a CSV cell
     * @returns {String} CSV string (cell)
     */
    processCell(row, fieldInfo) {
        return this.processValue(fieldInfo.value(row));
    }
    /**
     * Create the content of a specfic CSV row cell
     *
     * @param {T} value Value to be included in a CSV cell
     * @returns {String} Value stringified and processed
     */
    processValue(value) {
        const formatter = this.opts.formatters[typeof value];
        return formatter(value);
    }
}
exports.default = JSON2CSVBase;
//# sourceMappingURL=BaseParser.js.map