const User = require('./User');
const Property = require('./Property');
const Lease = require('./Lease');
const Payment = require('./Payment');
const Maintenance = require('./Maintenance');
const Notification = require('./Notification');

// Import all models
const models = {
  User,
  Property,
  Lease,
  Payment,
  Maintenance,
  Notification
};

// Create associations
Object.keys(models).forEach(modelName => {
  if (models[modelName].associate) {
    models[modelName].associate(models);
  }
});

// Export models and sequelize instance
module.exports = models;