const User = require('./User');
const Property = require('./Property');
const Lease = require('./Lease');
const Payment = require('./Payment');
const Maintenance = require('./Maintenance');
const Notification = require('./Notification');
const Document = require('./Document');
const Review = require('./Review');
const Message = require('./Message');
const AuditLog = require('./AuditLog');

const createAssociations = () => {
  // User associations
  User.hasMany(Property, { foreignKey: 'landlordId', as: 'properties' });
  User.hasMany(Lease, { foreignKey: 'tenantId', as: 'tenantLeases' });
  User.hasMany(Lease, { foreignKey: 'landlordId', as: 'landlordLeases' });
  User.hasMany(Payment, { foreignKey: 'tenantId', as: 'tenantPayments' });
  User.hasMany(Payment, { foreignKey: 'landlordId', as: 'landlordPayments' });
  User.hasMany(Maintenance, { foreignKey: 'tenantId', as: 'maintenanceRequests' });
  User.hasMany(Maintenance, { foreignKey: 'assignedTo', as: 'assignedMaintenance' });
  User.hasMany(Notification, { foreignKey: 'userId', as: 'notifications' });
  User.hasMany(Document, { foreignKey: 'uploadedBy', as: 'uploadedDocuments' });
  User.hasMany(Document, { foreignKey: 'userId', as: 'personalDocuments' });
  User.hasMany(Review, { foreignKey: 'reviewerId', as: 'reviewsGiven' });
  User.hasMany(Review, { foreignKey: 'revieweeId', as: 'reviewsReceived' });
  User.hasMany(Message, { foreignKey: 'senderId', as: 'sentMessages' });
  User.hasMany(Message, { foreignKey: 'receiverId', as: 'receivedMessages' });
  User.hasMany(AuditLog, { foreignKey: 'userId', as: 'auditLogs' });
  User.hasMany(AuditLog, { foreignKey: 'affectedUserId', as: 'affectedAuditLogs' });

  // Property associations
  Property.belongsTo(User, { foreignKey: 'landlordId', as: 'landlord' });
  Property.hasMany(Lease, { foreignKey: 'propertyId', as: 'leases' });
  Property.hasMany(Payment, { foreignKey: 'propertyId', as: 'payments' });
  Property.hasMany(Maintenance, { foreignKey: 'propertyId', as: 'maintenances' });
  Property.hasMany(Document, { foreignKey: 'propertyId', as: 'documents' });
  Property.hasMany(Review, { foreignKey: 'propertyId', as: 'reviews' });
  Property.hasMany(Message, { foreignKey: 'propertyId', as: 'messages' });

  // Lease associations
  Lease.belongsTo(Property, { foreignKey: 'propertyId', as: 'property' });
  Lease.belongsTo(User, { foreignKey: 'tenantId', as: 'tenant' });
  Lease.belongsTo(User, { foreignKey: 'landlordId', as: 'landlord' });
  Lease.hasMany(Payment, { foreignKey: 'leaseId', as: 'payments' });
  Lease.hasMany(Document, { foreignKey: 'leaseId', as: 'documents' });
  Lease.hasMany(Review, { foreignKey: 'leaseId', as: 'reviews' });

  // Payment associations
  Payment.belongsTo(Lease, { foreignKey: 'leaseId', as: 'lease' });
  Payment.belongsTo(Property, { foreignKey: 'propertyId', as: 'property' });
  Payment.belongsTo(User, { foreignKey: 'tenantId', as: 'tenant' });
  Payment.belongsTo(User, { foreignKey: 'landlordId', as: 'landlord' });

  // Maintenance associations
  Maintenance.belongsTo(Property, { foreignKey: 'propertyId', as: 'property' });
  Maintenance.belongsTo(User, { foreignKey: 'tenantId', as: 'tenant' });
  Maintenance.belongsTo(User, { foreignKey: 'assignedTo', as: 'assignedStaff' });
  Maintenance.belongsTo(User, { foreignKey: 'landlordId', as: 'landlord' });

  // Notification associations
  Notification.belongsTo(User, { foreignKey: 'userId', as: 'user' });

  // Document associations
  Document.belongsTo(User, { foreignKey: 'uploadedBy', as: 'uploader' });
  Document.belongsTo(Property, { foreignKey: 'propertyId', as: 'property' });
  Document.belongsTo(Lease, { foreignKey: 'leaseId', as: 'lease' });
  Document.belongsTo(User, { foreignKey: 'userId', as: 'user' });

  // Review associations
  Review.belongsTo(User, { foreignKey: 'reviewerId', as: 'reviewer' });
  Review.belongsTo(User, { foreignKey: 'revieweeId', as: 'reviewee' });
  Review.belongsTo(Property, { foreignKey: 'propertyId', as: 'property' });
  Review.belongsTo(Lease, { foreignKey: 'leaseId', as: 'lease' });

  // Message associations
  Message.belongsTo(User, { foreignKey: 'senderId', as: 'sender' });
  Message.belongsTo(User, { foreignKey: 'receiverId', as: 'receiver' });
  Message.belongsTo(Property, { foreignKey: 'propertyId', as: 'property' });
  Message.belongsTo(Lease, { foreignKey: 'leaseId', as: 'lease' });
  Message.belongsTo(Message, { foreignKey: 'parentMessageId', as: 'parentMessage' });

  // AuditLog associations
  AuditLog.belongsTo(User, { foreignKey: 'userId', as: 'user' });
  AuditLog.belongsTo(User, { foreignKey: 'affectedUserId', as: 'affectedUser' });
};

module.exports = { createAssociations };