const { testConnection } = require('./config/database');

const healthCheck = async () => {
  const checks = {
    database: false,
    memory: false,
    disk: false
  };

  try {
    // Check database connection
    await testConnection();
    checks.database = true;
  } catch (error) {
    console.error('Database health check failed:', error.message);
  }

  // Check memory usage
  const used = process.memoryUsage();
  const memoryUsage = used.heapUsed / used.heapTotal;
  checks.memory = memoryUsage < 0.8; // 80% threshold

  // Check disk space (simplified)
  checks.disk = true; // In production, you might want to actually check disk space

  const allHealthy = Object.values(checks).every(check => check);
  
  if (!allHealthy) {
    console.error('Health check failed:', checks);
    process.exit(1);
  }

  console.log('Health check passed:', checks);
  process.exit(0);
};

// Run health check if called directly
if (require.main === module) {
  healthCheck();
}

module.exports = healthCheck;